<form action="<?php echo e(route('commission-log.index')); ?>" method="GET">
    <div class="card-header row gutters-5">
        <div class="col text-center text-md-left">
            <h5 class="mb-md-0 h6"><?php echo e(translate('Commission History')); ?></h5>
        </div>
        <?php if(Auth::user()->user_type != 'seller'): ?>
        <div class="col-md-3 ml-auto">
            <select id="demo-ease" class="form-control form-control-sm aiz-selectpicker mb-2 mb-md-0" name="seller_id">
                <option value=""><?php echo e(translate('Choose Seller')); ?></option>
                <?php $__currentLoopData = \App\Models\Seller::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $seller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(isset($seller->user->id)): ?>
                    <option value="<?php echo e($seller->user->id); ?>" <?php if($seller->user->id == $seller_id): ?> selected <?php endif; ?> >
                        <?php echo e($seller->user->name); ?>

                    </option>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <?php endif; ?>
        <div class="col-md-3">
            <div class="form-group mb-0">
                <input type="text" class="form-control form-control-sm aiz-date-range" id="search" name="date_range"<?php if(isset($date_range)): ?> value="<?php echo e($date_range); ?>" <?php endif; ?> placeholder="<?php echo e(translate('Daterange')); ?>">
            </div>
        </div>
        <div class="col-md-2">
            <button class="btn btn-md btn-primary" type="submit">
                <?php echo e(translate('Filter')); ?>

            </button>
        </div>
    </div>
</form>
<div class="card-body">

    <table class="table aiz-table mb-0">
        <thead>
            <tr>
                <th>#</th>
                <th data-breakpoints="lg"><?php echo e(translate('Order Code')); ?></th>
                <th><?php echo e(translate('Admin Commission')); ?></th>
                <th><?php echo e(translate('Seller Earning')); ?></th>
                <th data-breakpoints="lg"><?php echo e(translate('Created At')); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $commission_history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e(($key+1)); ?></td>
                <td>
                    <?php if(isset($history->order)): ?>
                        <?php echo e($history->order->code); ?>

                    <?php else: ?>
                        <span class="badge badge-inline badge-danger">
                            translate('Order Deleted')
                        </span>
                    <?php endif; ?>
                </td>
                <td><?php echo e($history->admin_commission); ?></td>
                <td><?php echo e($history->seller_earning); ?></td>
                <td><?php echo e($history->created_at); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <div class="aiz-pagination mt-4">
        <?php echo e($commission_history->links()); ?>

    </div>
</div><?php /**PATH /home/elitedesigncom/ecommerce7.elitedesign.com.bd/resources/views/backend/reports/partials/commission_history_section.blade.php ENDPATH**/ ?>