

<?php $__env->startSection('content'); ?>

<div class="aiz-titlebar text-left mt-2 mb-3">
    <div class=" align-items-center">
        <h1 class="h3"><?php echo e(translate('Wallet Transaction Report')); ?></h1>
    </div>
</div>

<div class="row">
    <div class="col-md-10 mx-auto">
        <div class="card">
            <form action="<?php echo e(route('wallet-history.index')); ?>" method="GET">
                <div class="card-header row gutters-5">
                    <div class="col text-center text-md-left">
                        <h5 class="mb-md-0 h6"><?php echo e(translate('Wallet Transaction')); ?></h5>
                    </div>
                    <?php if(Auth::user()->user_type != 'seller'): ?>
                    <div class="col-md-3 ml-auto">
                        <select id="demo-ease" class="form-control form-control-sm aiz-selectpicker mb-2 mb-md-0" name="user_id">
                            <option value=""><?php echo e(translate('Choose User')); ?></option>
                            <?php $__currentLoopData = $users_with_wallet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>" <?php if($user->id == $user_id): ?> selected <?php endif; ?> >
                                    <?php echo e($user->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <?php endif; ?>
                    <div class="col-md-3">
                        <div class="form-group mb-0">
                            <input type="text" class="form-control form-control-sm aiz-date-range" id="search" name="date_range"<?php if(isset($date_range)): ?> value="<?php echo e($date_range); ?>" <?php endif; ?> placeholder="<?php echo e(translate('Daterange')); ?>">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <button class="btn btn-md btn-primary" type="submit">
                            <?php echo e(translate('Filter')); ?>

                        </button>
                    </div>
                </div>
            </form>
            <div class="card-body">

                <table class="table aiz-table mb-0">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo e(translate('Customer')); ?></th>
                            <th data-breakpoints="lg"><?php echo e(translate('Date')); ?></th>
                            <th><?php echo e(translate('Amount')); ?></th>
                            <th data-breakpoints="lg"><?php echo e(translate('Payment Method')); ?></th>
                            <th data-breakpoints="lg" class="text-right"><?php echo e(translate('Approval')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($key+1); ?></td>
                                <?php if($wallet->user != null): ?>
                                    <td><?php echo e($wallet->user->name); ?></td>
                                <?php else: ?>
                                    <td><?php echo e(translate('User Not found')); ?></td>
                                <?php endif; ?>
                                <td><?php echo e(date('d-m-Y', strtotime($wallet->created_at))); ?></td>
                                <td><?php echo e(single_price($wallet->amount)); ?></td>
                                <td><?php echo e(ucfirst(str_replace('_', ' ', $wallet ->payment_method))); ?></td>
                                <td class="text-right">
                                    <?php if($wallet->offline_payment): ?>
                                        <?php if($wallet->approval): ?>
                                            <span class="badge badge-inline badge-success"><?php echo e(translate('Approved')); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge-inline badge-info"><?php echo e(translate('Pending')); ?></span>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        N/A
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="aiz-pagination mt-4">
                    <?php echo e($wallets->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedesigncom/ecommerce7.elitedesign.com.bd/resources/views/backend/reports/wallet_history_report.blade.php ENDPATH**/ ?>